#pragma once

#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream.>
#include "tools.h"

using namespace std;

class CScnMain : public CXuiSceneImpl
{

protected:
    // Message map.
    CXuiControl btnXBox360Games;
    CXuiControl btnXBox1Games;
    CXuiControl btnXBoxLiveArcade;
    CXuiControl btnHomebrew;
	CXuiControl btnEmulators;
	CXuiControl btnFavourites;
	CXuiControl btnRecent;
	CXuiTextElement m_date;
	CXuiTextElement m_time;
	CXuiTextElement m_datetime;
	CXuiTextElement m_MBTemp;
	CXuiTextElement m_CPUTemp;
	CXuiTextElement m_GPUTemp;
	CXuiTextElement m_EDRAMTemp;
	CXuiTextElement m_IPAddress;
	CXuiTextElement m_TempInfo;
	CXuiTextElement m_HDD1Text;
	CXuiTextElement m_MU0Text;
	CXuiTextElement m_USB0Text;
	CXuiTextElement m_USB1Text;
	CXuiTextElement m_DiskInfo;
	CXuiTextElement m_GamerTag;
	CXuiTextElement m_SMCVer;
	CXuiTextElement m_Orientation;
	CXuiTextElement m_AVPack;
	CXuiTextElement m_TrayStat;
	CXuiTextElement m_InfoText;
	CXuiTextElement m_GamerScore;
	CXuiImageElement m_GamerPic;
	CXuiControl m_ProfileBack;

	XUI_BEGIN_MSG_MAP()
        XUI_ON_XM_INIT( OnInit )
        XUI_ON_XM_NOTIFY_PRESS( OnNotifyPress )
		XUI_ON_XM_TIMER( OnTimer )
	XUI_END_MSG_MAP()

    //----------------------------------------------------------------------------------
    // Performs initialization tasks - retreives controls.
    //----------------------------------------------------------------------------------
    HRESULT OnInit( XUIMessageInit* pInitData, BOOL& bHandled );
    HRESULT OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled );
	HRESULT OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled );
	HRESULT RenderGame(IDirect3DDevice9 *pDevice);

public:

    // Define the class. The class name must match the ClassOverride property
    // set for the scene in the UI Authoring tool.
    XUI_IMPLEMENT_CLASS( CScnMain, L"ScnMain", XUI_CLASS_TABSCENE )
};
